/**
 * Reformer for Elementor
 * Customizable contact form for Elementor editor
 * Exclusively on https://1.envato.market/reformer-elementor
 *
 * @encoding        UTF-8
 * @version         1.0.2
 * @copyright       (C) 2018 - 2021 Merkulove ( https://merkulov.design/ ). All rights reserved.
 * @license         Envato License https://1.envato.market/KYbje
 * @contributors    Nemirovskiy Vitaliy (nemirovskiyvitaliy@gmail.com), Dmitry Merkulov (dmitry@merkulov.design), Cherviakov Vlad (vladchervjakov@gmail.com)
 * @support         help@merkulov.design
 **/

const mdpReformerElementor = {
    formSubmit: ( wrapperName ) => {

        function serialize( form ) {
            let field, s = [];
            if ( typeof form == 'object' && form.nodeName === "FORM" ) {
                const len = form.elements.length;
                for ( let i = 0; i < len; i++ ) {
                    field = form.elements[i];
                    const label = field.previousElementSibling &&
                        field.previousElementSibling.classList.contains( 'mdp-reformer-elementor-field-label' ) ?
                        field.previousElementSibling :
                        field.parentElement.classList.contains( 'mdp-reformer-elementor-range-field-wrapper' ) &&
                        field.parentElement.previousElementSibling.classList.contains( 'mdp-reformer-elementor-field-label' ) ?
                        field.parentElement.previousElementSibling :
                        null;

                    if ( field.name && !field.disabled && field.type !== 'file' && field.type !== 'reset' && field.type !== 'submit' && field.type !== 'button' ) {
                        if ( field.type === 'select-multiple' ) {
                            for ( let j = form.elements[i].options.length - 1; j >= 0; j-- ) {
                                if ( field.options[j].selected ) {
                                    s[s.length] = encodeURIComponent( 'select_field_' + j ) + '[]' + '=' + encodeURIComponent( field.type )
                                        + '&' + encodeURIComponent( 'select_field_' + j ) + '[]' + '=' + encodeURIComponent( label ? label.textContent : field.options[j].name )
                                        + '&' + encodeURIComponent( 'select_field_' + j ) + '[]' + '=' + encodeURIComponent( field.options[j].value )
                                        + '&' + encodeURIComponent( 'select_field_' + j ) + '[]' + '=' + encodeURIComponent( field.options[j].name );
                                }
                            }
                        } else if ( ( field.type !== 'checkbox' && field.type !== 'radio' ) || field.checked ) {
                            s[s.length] = encodeURIComponent( 'field_' + i ) + '[]' + '=' + encodeURIComponent( field.type )
                                + '&' + encodeURIComponent( 'field_' + i ) + '[]' + '=' + encodeURIComponent( label ? label.textContent : field.name )
                                + '&' + encodeURIComponent( 'field_' + i ) + '[]' + '=' + encodeURIComponent( field.value )
                                + '&' + encodeURIComponent( 'field_' + i ) + '[]' + '=' + encodeURIComponent( field.name );
                        }
                    } else if ( field.type === 'file' ) {
                        s[s.length] = encodeURIComponent( 'field_' + i ) + '[]' + '=' + encodeURIComponent( field.type )
                            + '&' + encodeURIComponent( 'field_' + i ) + '[]' + '=' + encodeURIComponent( field.name )
                            + '&' + encodeURIComponent( 'field_' + i ) + '[]' + '=' + encodeURIComponent( 'mdp_reformer_file_send' )
                            + '&' + encodeURIComponent( 'field_' + i ) + '[]' + '=' + encodeURIComponent( field.accept.replace( /\./g, '' ).toLowerCase() )
                            + '&' + encodeURIComponent( 'field_' + i ) + '[]' + '=' + encodeURIComponent( field.dataset.maxsize );
                    }
                }
            }
            return s.join( '&' ).replace( /%20/g, '+' );
        }

        const $form = document.querySelector( `.${wrapperName} .mdp-reformer-elementor-form` );
        const $successMessage = document.querySelector( `.${wrapperName} .mdp-reformer-elementor-success-message` );
        const $errorMessage = document.querySelector( `.${wrapperName} .mdp-reformer-elementor-error-message` );

        function sendData( e ) {
            e.preventDefault();
            const xhr = new XMLHttpRequest();

            const formData = new FormData( $form );

            formData.append( 'action', 'mdp_reformer_send' );
            formData.append( 'mdp_reformer_nonce', mdpReformerElementorWP.nonce )
            formData.append( 'mdp_reformer_send', serialize( $form ) );

            xhr.onreadystatechange = () => {
                if ( xhr.readyState === 4 && xhr.status === 200 ) {
                    const response = JSON.parse( xhr.responseText );
                    if ( response.success ) {
                        $errorMessage.style.display = 'none';
                        $successMessage.style.display = 'block';
                        $successMessage.innerHTML = response.data;
                    } else {
                        $successMessage.style.display = 'none';
                        $errorMessage.style.display = 'block';
                        $errorMessage.innerHTML = response.data;
                    }
                }
            }

            xhr.open( 'POST', mdpReformerElementorWP.endpoint, true );
            xhr.send( formData );

        }

        if ( !elementorFrontend.isEditMode() ) {
            $form.addEventListener('submit', sendData);
        }
    }


};

/**
 * Init for Front-End
 * @param callback
 */
jQuery( window ).on( 'elementor/frontend/init', function () {

    elementorFrontend.hooks.addAction( 'frontend/element_ready/global', function( $scope ) {

        if ( $scope[0].classList.contains( 'elementor-widget-mdp-reformer-elementor' ) ) {
            mdpReformerElementor.formSubmit.call( mdpReformerElementor, `elementor-element-${$scope[0].dataset.id}` );
        }
    } );

} );