<?php

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

if( ! class_exists( 'Abolire_Elementor_Extensions' ) ) {
    final class Abolire_Elementor_Extensions {

        private static $_instance = null;

        
        public function __construct() {
            add_action( 'elementor/elements/categories_registered', array( $this, 'add_widget_categories' ) );
            add_action( 'init', array( $this, 'elementor_widgets' ),  100 );
            add_filter( 'abolire_generate_post_builder', array( $this, 'render_post_builder' ), 10, 2 );

            add_action( 'elementor/controls/controls_registered', array( $this, 'modify_controls' ), 10, 1 );
            add_action('elementor/editor/before_enqueue_styles', array( $this, 'style' ) );
            add_filter( 'elementor/controls/animations/additional_animations', array( $this, 'additional_animations' ), 10 );
        }

        public static function instance () {
            if ( is_null( self::$_instance ) ) {
                self::$_instance = new self();
            }
            return self::$_instance;
        }
        
        public function add_widget_categories( $elements_manager ) {
            $elements_manager->add_category(
                'abolire-elements',
                [
                    'title' => esc_html__( 'Abolire Elements', 'abolire' ),
                    'icon' => 'fa fa-shopping-bag',
                ]
            );

            $elements_manager->add_category(
                'abolire-header-elements',
                [
                    'title' => esc_html__( 'Abolire Header Elements', 'abolire' ),
                    'icon' => 'fa fa-shopping-bag',
                ]
            );

        }

        public function elementor_widgets() {
            // general elements
            get_template_part( 'inc/vendors/elementor/widgets/heading' );
            get_template_part( 'inc/vendors/elementor/widgets/posts' );
            get_template_part( 'inc/vendors/elementor/widgets/call_to_action' );
            get_template_part( 'inc/vendors/elementor/widgets/features_box' );
            get_template_part( 'inc/vendors/elementor/widgets/social_links' );
            get_template_part( 'inc/vendors/elementor/widgets/testimonials' );
            get_template_part( 'inc/vendors/elementor/widgets/brands' );
            get_template_part( 'inc/vendors/elementor/widgets/process' );
            get_template_part( 'inc/vendors/elementor/widgets/popup_video' );
            get_template_part( 'inc/vendors/elementor/widgets/instagram' );
            get_template_part( 'inc/vendors/elementor/widgets/banner' );
            get_template_part( 'inc/vendors/elementor/widgets/countdown' );
            get_template_part( 'inc/vendors/elementor/widgets/nav_menu' );
            get_template_part( 'inc/vendors/elementor/widgets/team' );
            get_template_part( 'inc/vendors/elementor/widgets/agents' );

            get_template_part( 'inc/vendors/elementor/widgets/tabs' );
            get_template_part( 'inc/vendors/elementor/widgets/maps' );
            get_template_part( 'inc/vendors/elementor/widgets/gallery' );
            get_template_part( 'inc/vendors/elementor/widgets/apartment-info' );

            // header elements
            get_template_part( 'inc/vendors/elementor/header-widgets/logo' );
            get_template_part( 'inc/vendors/elementor/header-widgets/primary_menu' );
            get_template_part( 'inc/vendors/elementor/header-widgets/search_form' );
            get_template_part( 'inc/vendors/elementor/header-widgets/schedule_visit' );

            if ( abolire_is_mailchimp_activated() ) {
                get_template_part( 'inc/vendors/elementor/widgets/mailchimp' );
            }
            
            if ( abolire_is_revslider_activated() ) {
                get_template_part( 'inc/vendors/elementor/widgets/revslider' );
            }
        }

        public function style() {
            wp_enqueue_style('abolire-flaticon',  get_template_directory_uri() . '/css/flaticon.css');
        }

        public function modify_controls( $controls_registry ) {
            // Get existing icons
            $icons = $controls_registry->get_control( 'icon' )->get_settings( 'options' );
            // Append new icons
            $new_icons = array_merge(
                array(
                    'flaticon-search' => 'flaticon-search', 'flaticon-calendar' => 'flaticon-calendar', 'flaticon-arrow' => 'flaticon-arrow', 'flaticon-arrow-1' => 'flaticon-arrow-1', 'flaticon-arrow-2' => 'flaticon-arrow-2', 'flaticon-arrow-3' => 'flaticon-arrow-3', 'flaticon-audio' => 'flaticon-audio', 'flaticon-start' => 'flaticon-start', 'flaticon-mission' => 'flaticon-mission', 'flaticon-wall' => 'flaticon-wall', 'flaticon-yoga' => 'flaticon-yoga', 'flaticon-dog' => 'flaticon-dog', 'flaticon-rent' => 'flaticon-rent', 'flaticon-pool' => 'flaticon-pool', 'flaticon-play' => 'flaticon-play', 'flaticon-park' => 'flaticon-park', 'flaticon-internet' => 'flaticon-internet', 'flaticon-golf' => 'flaticon-golf', 'flaticon-team' => 'flaticon-team', 'flaticon-add' => 'flaticon-add', 'flaticon-quote' => 'flaticon-quote', 'flaticon-read' => 'flaticon-read', 'flaticon-bank' => 'flaticon-bank', 'flaticon-gps' => 'flaticon-gps', 'flaticon-line' => 'flaticon-line', 'flaticon-comment' => 'flaticon-comment', 'flaticon-user' => 'flaticon-user', 'flaticon-apartment' => 'flaticon-apartment', 'flaticon-architecture-and-city' => 'flaticon-architecture-and-city', 'flaticon-next' => 'flaticon-next', 'flaticon-down-arrow' => 'flaticon-down-arrow', 'flaticon-right-arrow' => 'flaticon-right-arrow', 'flaticon-search-1' => 'flaticon-search-1', 'flaticon-left-arrow' => 'flaticon-left-arrow', 'flaticon-heart' => 'flaticon-heart', 'flaticon-shopping-cart' => 'flaticon-shopping-cart', 'flaticon-calendar-1' => 'flaticon-calendar-1', 'flaticon-bag' => 'flaticon-bag', 'flaticon-placeholder' => 'flaticon-placeholder', 'flaticon-ui' => 'flaticon-ui', 'flaticon-story' => 'flaticon-story', 'flaticon-right-quote-sign' => 'flaticon-right-quote-sign', 'flaticon-return' => 'flaticon-return', 'flaticon-resume' => 'flaticon-resume', 'flaticon-menu' => 'flaticon-menu', 'flaticon-grid' => 'flaticon-grid', 'flaticon-menu-1' => 'flaticon-menu-1'
                ),
                $icons                
            );
            // Then we set a new list of icons as the options of the icon control
            $controls_registry->get_control( 'icon' )->set_settings( 'options', $new_icons );
        }

        public function additional_animations($animations = array()) {
            $additional_animations = array(
                'ApusTheme' => [
                    'moveInDown' => esc_html__('Move In Down', 'abolire'),
                    'moveInLeft' => esc_html__('Move In Left', 'abolire'),
                    'moveInRight' => esc_html__('Move In Right', 'abolire'),
                    'moveInUp' => esc_html__('Move In Up', 'abolire'),
                    'moveOutDown' => esc_html__('Move Out Down', 'abolire'),
                    'moveOutLeft' => esc_html__('Move Out Left', 'abolire'),
                    'moveOutRight' => esc_html__('Move Out Right', 'abolire'),
                    'moveOutUp' => esc_html__('Move Out Up', 'abolire'),
                ],
            );
            return array_merge( $animations, $additional_animations );
        }

        public function render_page_content($post_id) {
            if ( class_exists( 'Elementor\Core\Files\CSS\Post' ) ) {
                $css_file = new Elementor\Core\Files\CSS\Post( $post_id );
                $css_file->enqueue();
            }

            return Elementor\Plugin::instance()->frontend->get_builder_content_for_display( $post_id );
        }

        public function render_post_builder($html, $post) {
            if ( !empty($post) && !empty($post->ID) ) {
                return $this->render_page_content($post->ID);
            }
            return $html;
        }
    }
}

if ( did_action( 'elementor/loaded' ) ) {
    // Finally initialize code
    Abolire_Elementor_Extensions::instance();
}