<?php

//namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

class Abolire_Elementor_Schedule_Visit extends Elementor\Widget_Base {

	public function get_name() {
        return 'apus_element_schedule_visit';
    }

	public function get_title() {
        return esc_html__( 'Apus Header Schedule Visit', 'abolire' );
    }
    
	public function get_categories() {
        return [ 'abolire-header-elements' ];
    }

	protected function _register_controls() {

        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__( 'Content', 'abolire' ),
                'tab' => Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

   		$this->add_control(
            'el_class',
            [
                'label'         => esc_html__( 'Extra class name', 'abolire' ),
                'type'          => Elementor\Controls_Manager::TEXT,
                'placeholder'   => esc_html__( 'If you wish to style particular content element differently, please add a class name to this field and refer to it in your custom CSS file.', 'abolire' ),
            ]
        );

        $this->end_controls_section();
    }

	protected function render() {
        $settings = $this->get_settings();

        extract( $settings );
        ?>
        <div class="apus-schedule-visit <?php echo esc_attr($el_class); ?>">
            <a href="#apus-schedule-visit-wrapper" class="top-icon schedule-visit-btn"><i class="flaticon-calendar"></i></a>
        </div>
        <?php
    }
}

Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Abolire_Elementor_Schedule_Visit );