<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

class Abolire_Elementor_Banner extends Widget_Base {

	public function get_name() {
        return 'apus_element_banner';
    }

	public function get_title() {
        return esc_html__( 'Apus Banner', 'abolire' );
    }
    
	public function get_categories() {
        return [ 'abolire-elements' ];
    }

	protected function _register_controls() {

        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__( 'Banner', 'abolire' ),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'title',
            [
                'label' => esc_html__( 'Title', 'abolire' ),
                'type' => Controls_Manager::TEXT,
                'input_type' => 'text',
                'placeholder' => esc_html__( 'Enter your title here', 'abolire' ),
            ]
        );

        $this->add_control(
            'content',
            [
                'label' => esc_html__( 'Content', 'abolire' ),
                'type' => Controls_Manager::WYSIWYG,
                'placeholder' => esc_html__( 'Enter your content here', 'abolire' ),
            ]
        );
        $this->add_control(
            'link',
            [
                'label' => esc_html__( 'URL', 'abolire' ),
                'type' => Controls_Manager::TEXT,
                'input_type' => 'url',
                'placeholder' => esc_html__( 'Enter your Button Link here', 'abolire' ),
            ]
        );
        $this->add_control(
            'btn_text',
            [
                'label' => esc_html__( 'Button Text', 'abolire' ),
                'type' => Controls_Manager::TEXT,
                'placeholder' => esc_html__( 'Enter your button text here', 'abolire' ),
            ]
        );

        $this->add_control(
            'btn_style',
            [
                'label' => esc_html__( 'Button Style', 'abolire' ),
                'type' => Controls_Manager::SELECT,
                'options' => array(
                    'btn-theme' => esc_html__('Theme Color', 'abolire'),
                    'btn-theme btn-outline' => esc_html__('Theme Outline Color', 'abolire'),
                    'btn-default' => esc_html__('Default ', 'abolire'),
                    'btn-primary' => esc_html__('Primary ', 'abolire'),
                    'btn-success' => esc_html__('Success ', 'abolire'),
                    'btn-info' => esc_html__('Info ', 'abolire'),
                    'btn-warning' => esc_html__('Warning ', 'abolire'),
                    'btn-danger' => esc_html__('Danger ', 'abolire'),
                    'btn-pink' => esc_html__('Pink ', 'abolire'),
                    'btn-white' => esc_html__('White ', 'abolire'),
                ),
                'default' => 'btn-default'
            ]
        );
        $this->add_control(
            'img_src',
            [
                'name' => 'image',
                'label' => esc_html__( 'Image', 'abolire' ),
                'type' => Controls_Manager::MEDIA,
                'placeholder'   => esc_html__( 'Upload Image Here', 'abolire' ),
            ]
        );
        $this->add_responsive_control(
            'content_align',
            [
                'label' => esc_html__( 'Content Alignment', 'abolire' ),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => esc_html__( 'Left', 'abolire' ),
                        'icon' => 'fa fa-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__( 'Center', 'abolire' ),
                        'icon' => 'fa fa-align-center',
                    ],
                    'right' => [
                        'title' => esc_html__( 'Right', 'abolire' ),
                        'icon' => 'fa fa-align-right',
                    ],
                    'justify' => [
                        'title' => esc_html__( 'Justified', 'abolire' ),
                        'icon' => 'fa fa-align-justify',
                    ],
                ],
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .inner' => 'text-align: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'style',
            [
                'label' => esc_html__( 'Style', 'abolire' ),
                'type' => Controls_Manager::SELECT,
                'options' => array(
                    'style1' => esc_html__('Style 1', 'abolire'),
                ),
                'default' => 'style1'
            ]
        );
   		$this->add_control(
            'el_class',
            [
                'label'         => esc_html__( 'Extra class name', 'abolire' ),
                'type'          => Controls_Manager::TEXT,
                'placeholder'   => esc_html__( 'If you wish to style particular content element differently, please add a class name to this field and refer to it in your custom CSS file.', 'abolire' ),
            ]
        );

        $this->end_controls_section();

    }

	protected function render() {

        $settings = $this->get_settings();

        extract( $settings );

        $img_bg_src = ( isset( $img_bg_src['id'] ) && $img_bg_src['id'] != 0 ) ? wp_get_attachment_url( $img_bg_src['id'] ) : '';
        $style_bg = '';
        if ( !empty($img_bg_src) ) {
            $style_bg = 'style="background-image:url('.esc_url($img_bg_src).')"';
        }
        ?>
        <div class="widget-banner <?php echo esc_attr($el_class.' '.$style); ?>">
            <?php
            if ( !empty($img_src['id']) ) {
            ?>
                <div class="banner-image">
                    <?php echo abolire_get_attachment_thumbnail($img_src['id'], 'full'); ?>
                </div>
            <?php } ?>
            <div class="inner <?php echo esc_attr( (!empty($img_src['id']))?'p-ab':'' ); ?>">
                <?php if( !empty($title) ) { ?>
                    <h2 class="title" >
                       <?php echo trim( $title ); ?>
                    </h2>
                <?php } ?>
                <div class="banner-content">
                    <?php if ( !empty($content) ) { ?>
                        <?php echo trim($content); ?>
                    <?php } ?>
                </div>
                <?php if ( !empty($btn_text) ) { ?>
                    <a class="btn <?php echo esc_attr(!empty($btn_style) ? $btn_style : ''); ?>" href="<?php echo esc_url($link); ?>" ><?php echo trim($btn_text); ?></a>
                <?php } ?>
            </div>
        </div>
        <?php

    }

}

Plugin::instance()->widgets_manager->register_widget_type( new Abolire_Elementor_Banner );