<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

class Abolire_Elementor_Maps extends Widget_Base {

	public function get_name() {
        return 'apus_element_maps';
    }

	public function get_title() {
        return esc_html__( 'Apus Maps', 'abolire' );
    }

    public function get_icon() {
        return 'eicon-google-maps';
    }

	public function get_categories() {
        return [ 'abolire-elements' ];
    }

	protected function _register_controls() {

        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__( 'Maps', 'abolire' ),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $repeater = new Repeater();

        $repeater->add_control(
            'title', [
                'label' => esc_html__( 'Title', 'abolire' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
            ]
        );

        $repeater->add_control(
            'image',
            [
                'label' => esc_html__( 'Image', 'abolire' ),
                'type' => Controls_Manager::MEDIA,
                'placeholder'   => esc_html__( 'Upload Image Here', 'abolire' ),
            ]
        );

        $repeater->add_control(
            'latitude', [
                'label' => esc_html__( 'Latitude', 'abolire' ),
                'type' => Controls_Manager::TEXT,
                'placeholder' => esc_html__( 'Enter latitude here' , 'abolire' ),
            ]
        );

        $repeater->add_control(
            'longitude', [
                'label' => esc_html__( 'Longitude', 'abolire' ),
                'type' => Controls_Manager::TEXT,
                'placeholder' => esc_html__( 'Enter longitude here' , 'abolire' ),
            ]
        );
        
        $this->add_control(
            'pins',
            [
                'label' => esc_html__( 'Pins', 'abolire' ),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
            ]
        );

        $this->add_control(
            'height', [
                'label' => esc_html__( 'Height', 'abolire' ),
                'type' => Controls_Manager::TEXT,
                'default' => '400',
            ]
        );

   		$this->add_control(
            'el_class',
            [
                'label'         => esc_html__( 'Extra class name', 'abolire' ),
                'type'          => Controls_Manager::TEXT,
                'placeholder'   => esc_html__( 'If you wish to style particular content element differently, please add a class name to this field and refer to it in your custom CSS file.', 'abolire' ),
            ]
        );

        $this->end_controls_section();
    }

	protected function render() {
        $settings = $this->get_settings();

        extract( $settings );

        

        ?>
        <div class="widget-maps <?php echo esc_attr($el_class); ?>">
            <?php if ( $pins ) { ?>
                <div class="hidden maps-pins-wrapper">
                    <?php foreach ($pins as $pin) { ?>
                        <div class="maps-pin-item" data-latitude="<?php echo esc_attr(!empty($pin['latitude']) ? $pin['latitude'] : ''); ?>" data-longitude="<?php echo esc_attr(!empty($pin['longitude']) ? $pin['longitude'] : ''); ?>">
                            <div class="pin-content-wrtapper">
                                <?php
                                if ( !empty($pin['image']['id']) ) {
                                ?>
                                    <div class="pin-image">
                                        <?php echo wp_get_attachment_image($pin['image']['id'], 'full'); ?>
                                    </div>
                                <?php } ?>
                                <?php if ( !empty($pin['title']) ) { ?>
                                    <h3 class="pin-title"><?php echo esc_html($pin['title']); ?></h3>
                                <?php } ?>
                            </div>
                        </div>
                    <?php } ?>
                </div>
            <?php } ?>
            <div id="widget-maps-init" class="widget-maps-init" style="height: <?php echo esc_attr($height); ?>px;"></div>
        </div>
        <?php
    }

}

Plugin::instance()->widgets_manager->register_widget_type( new Abolire_Elementor_Maps );