jQuery(document).ready(function($){
	"use strict";
	var abolire_upload;
	var abolire_selector;

	function abolire_add_file(event, selector) {

		var upload = $(".uploaded-file"), frame;
		var $el = $(this);
		abolire_selector = selector;

		event.preventDefault();

		// If the media frame already exists, reopen it.
		if ( abolire_upload ) {
			abolire_upload.open();
			return;
		} else {
			// Create the media frame.
			abolire_upload = wp.media.frames.abolire_upload =  wp.media({
				// Set the title of the modal.
				title: "Select Image",

				// Customize the submit button.
				button: {
					// Set the text of the button.
					text: "Selected",
					// Tell the button not to close the modal, since we're
					// going to refresh the page when the image is selected.
					close: false
				}
			});

			// When an image is selected, run a callback.
			abolire_upload.on( 'select', function() {
				// Grab the selected attachment.
				var attachment = abolire_upload.state().get('selection').first();

				abolire_upload.close();
				abolire_selector.find('.upload_image').val(attachment.attributes.url).change();
				if ( attachment.attributes.type == 'image' ) {
					abolire_selector.find('.abolire_screenshot').empty().hide().prepend('<img src="' + attachment.attributes.url + '">').slideDown('fast');
				}
			});

		}
		// Finally, open the modal.
		abolire_upload.open();
	}

	function abolire_remove_file(selector) {
		selector.find('.abolire_screenshot').slideUp('fast').next().val('').trigger('change');
	}
	
	$('body').on('click', '.abolire_upload_image_action .remove-image', function(event) {
		abolire_remove_file( $(this).parent().parent() );
	});

	$('body').on('click', '.abolire_upload_image_action .add-image', function(event) {
		abolire_add_file(event, $(this).parent().parent());
	});

});