<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

get_header();
$sidebar_configs = abolire_get_apartment_layout_configs();

global $post;
$style = '';
$thumbnail_url = get_the_post_thumbnail_url($post->ID, 'full');
if ( !empty($thumbnail_url) ) {
    $style = 'style="background-image:url('. $thumbnail_url .');"';
}
?>

<div class="top-info-detail-v1 apartment-info-detail" <?php echo trim($style); ?>>
	<div class="container">
		<div class="entry-title-detail-wrapper">
	    	<?php the_title('<h1 class="entry-title-detail">', '</h1>'); ?>
	    	<!-- address -->
	    	<?php
	    	$address = get_post_meta( $post->ID, APUS_ABOLIRE_PREFIX.'address', true );
	    	if ( $address ) {
	    		?>
	    		<div class="entry-address"><?php echo trim($address); ?></div>
	    		<?php
	    	}
	    	?>
	    </div>		
	</div>
</div>
<section id="main-container" class="main-content  <?php echo apply_filters('abolire_apartment_content_class', 'container');?> inner">
	<?php abolire_before_content( $sidebar_configs ); ?>
	<div class="row">
		<?php abolire_display_sidebar_left( $sidebar_configs ); ?>

		<div id="main-content" class="col-sm-12 <?php echo esc_attr($sidebar_configs['main']['class']); ?>">
			<main id="main" class="site-main detail-apartment <?php echo esc_attr( (count($sidebar_configs)>1)?'has-sidebar':'' ); ?>" role="main">

			<?php
				// Start the Loop.
				while ( have_posts() ) : the_post();

					?>
					<div class="entry-description">
		                <?php the_content(); ?>
		            </div><!-- /entry-content -->
					<?php
					if ( abolire_get_config('show_apartment_recent') ) {
						get_template_part( 'template-apartment/recent-apartment' );
					}

				// End the loop.
				endwhile;
			?>

			</main><!-- .site-main -->
		</div><!-- .content-area -->
		
		<?php abolire_display_sidebar_right( $sidebar_configs ); ?>
		
	</div>
</section>
<?php get_footer(); ?>