<?php 
    $thumbsize = !isset($thumbsize) ? abolire_get_config( 'blog_item_thumbsize', 'full' ) : $thumbsize;
    $thumb = abolire_display_post_thumb($thumbsize);
?>
<article <?php post_class('post post-grid post-grid-related'); ?>>
    
    <?php
	    if ( !empty($thumb) ) {
	        ?>
	        <div class="image p-relative">
	            <?php echo trim($thumb); ?>

                <div class="entry-date-time">
                    <div class="entry-date-wrap">
                        <?php get_the_date(); ?>
                        <span class="day"><?php the_time( 'd' ); ?> </span>
                        <span class="month"><?php the_time( 'M' ); ?> </span> 
                    </div>
                </div>               

	        </div>
	        <?php
	    }
	?>
    <?php if (get_the_title()) { ?>
        <h4 class="entry-title">
            <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
        </h4>
    <?php } ?>


    <?php if(has_excerpt()){?>
        <div class="description"><?php echo abolire_substring( get_the_excerpt(),8, '...' ); ?></div>
    <?php } ?>


</article>
