<?php
$post_format = get_post_format();
global $post;
?>
<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
    <div class="top-info-detail">
        <?php if( $post_format == 'link' ) {
            $format = abolire_post_format_link_helper( get_the_content(), get_the_title() );
            $title = $format['title'];
            $link = abolire_get_link_attributes( $title );
            $thumb = abolire_post_thumbnail('', $link);
            echo trim($thumb);
        } else { ?>
            <div class="entry-thumb <?php echo  (!has_post_thumbnail() ? 'no-thumb' : ''); ?>">
                <?php
                    $thumb = abolire_post_thumbnail();
                    echo trim($thumb);
                ?>
            </div>
        <?php } ?>

    </div>
	<div class="entry-content-detail">
        <div class="top-info-post-detail">
            <div class="entry-date">
                <?php the_time( get_option('date_format', 'd M, Y') ); ?>
            </div>
            <a href="<?php echo esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ); ?>">
                <?php echo get_the_author(); ?>
            </a>

            <span class="comments"><?php comments_number( esc_html__('0 Comments', 'abolire'), esc_html__('1 Comment', 'abolire'), esc_html__('% Comments', 'abolire') ); ?></span>            
        </div>

        <?php the_title('<h1 class="entry-title-detail">', '</h1>'); ?>

    	<div class="single-info info-bottom">
            <div class="entry-description">
                <?php the_content(); ?>
            </div><!-- /entry-content -->
    		<?php
    		wp_link_pages( array(
    			'before'      => '<div class="page-links"><span class="page-links-title">' . esc_html__( 'Pages:', 'abolire' ) . '</span>',
    			'after'       => '</div>',
    			'link_before' => '<span>',
    			'link_after'  => '</span>',
    			'pagelink'    => '<span class="screen-reader-text">' . esc_html__( 'Page', 'abolire' ) . ' </span>%',
    			'separator'   => '',
    		) );
    		?>
            <?php  
                $posttags = get_the_tags();
            ?>
            <?php if( !empty($posttags) || abolire_get_config('show_blog_social_share', false) ){ ?>
        		<div class="tag-social clearfix">
                    <?php abolire_post_tags(); ?>
        			<?php if( abolire_get_config('show_blog_social_share', false) ) {
        				get_template_part( 'template-parts/sharebox' );
        			} ?>
        		</div>
            <?php } ?>
            <?php
                //Previous/next post navigation.
                the_post_navigation( array(
                    'next_text' => '<span class="meta-nav" aria-hidden="true"><span class="navi">' . esc_html__( 'Next', 'abolire' ) . '</span> <i class="flaticon-arrow-2"></i></span> ' .
                        '<span class="inner">'.
                        '<span class="title-direct">%title</span></span>',
                    'prev_text' => '<span class="meta-nav" aria-hidden="true"><i class="flaticon-arrow"></i><span class="navi"> ' . esc_html__( 'Prev', 'abolire' ) . '</span></span> ' .
                        '<span class="inner">'.
                        '<span class="title-direct">%title</span></span>',
                ) );
            ?>
    	</div>
    </div>
</article>