<?php
/**
 * Plugin Name: Apus Abolire
 * Plugin URI: http://apusthemes.com/apus-abolire/
 * Description: Powerful plugin to create a apartment on your website.
 * Version: 1.0.0
 * Author: Habq
 * Author URI: http://apusthemes.com/
 * Requires at least: 3.8
 * Tested up to: 5.2
 *
 * Text Domain: apus-abolire
 * Domain Path: /languages/
 *
 * @package apus-abolire
 * @category Plugins
 * @author Habq
 */
if ( ! defined( 'ABSPATH' ) ) {
  	exit;
}

if ( !class_exists("Apus_Abolire") ) {
	
	final class Apus_Abolire {

		private static $instance;

		public static function getInstance() {
			if ( ! isset( self::$instance ) && ! ( self::$instance instanceof Apus_Abolire ) ) {
				self::$instance = new Apus_Abolire;
				self::$instance->setup_constants();
				self::$instance->load_textdomain();

				self::$instance->includes();
			}

			return self::$instance;
		}
		/**
		 *
		 */
		public function setup_constants(){
			define( 'APUS_ABOLIRE_PLUGIN_VERSION', '1.0.0' );

			define( 'APUS_ABOLIRE_PLUGIN_DIR', plugin_dir_path( __FILE__ ) );
			define( 'APUS_ABOLIRE_PLUGIN_URL', plugin_dir_url( __FILE__ ) );
			define( 'APUS_ABOLIRE_PREFIX', 'apartment_' );
		}

		public function includes() {
			// post type
			require_once APUS_ABOLIRE_PLUGIN_DIR . 'includes/post-types/class-post-type-apartment.php';

			//
			require_once APUS_ABOLIRE_PLUGIN_DIR . 'includes/class-template-loader.php';
			require_once APUS_ABOLIRE_PLUGIN_DIR . 'includes/class-mixes.php';
		}

		/**
		 *
		 */
		public function load_textdomain() {
			// Set filter for Apus_Abolire's languages directory
			$lang_dir = APUS_ABOLIRE_PLUGIN_DIR . 'languages/';
			$lang_dir = apply_filters( 'apus_abolire_languages_directory', $lang_dir );

			// Traditional WordPress plugin locale filter
			$locale = apply_filters( 'plugin_locale', get_locale(), 'apus-abolire' );
			$mofile = sprintf( '%1$s-%2$s.mo', 'apus-abolire', $locale );

			// Setup paths to current locale file
			$mofile_local  = $lang_dir . $mofile;
			$mofile_global = WP_LANG_DIR . '/apus-abolire/' . $mofile;

			if ( file_exists( $mofile_global ) ) {
				// Look in global /wp-content/languages/apus-abolire folder
				load_textdomain( 'apus-abolire', $mofile_global );
			} elseif ( file_exists( $mofile_local ) ) {
				// Look in local /wp-content/plugins/apus-abolire/languages/ folder
				load_textdomain( 'apus-abolire', $mofile_local );
			} else {
				// Load the default language files
				load_plugin_textdomain( 'apus-abolire', false, $lang_dir );
			}
		}
	}
}

function Apus_Abolire() {
	return Apus_Abolire::getInstance();
}

add_action( 'plugins_loaded', 'Apus_Abolire' );